#pragma once

#include "key_ring.h"

#include <passport/infra/libs/cpp/utils/crypto/hash.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <unordered_map>

namespace NPassport::NLbchdb::NCrypto {
    class TEncryptor {
    public:
        enum class EKeyRing {
            Restore,
            YasmsPrivate,
        };
        using TKeyRingMap = std::unordered_map<EKeyRing, TKeyRingHolderWithDefaultKey>;

        explicit TEncryptor(TKeyRingMap&& keyRingMap);

        struct TEncryptResult {
            ui64 KeyId = 0;
            NUtils::TCrypto::TCiphertext Crypt;
        };
        TEncryptResult Encrypt(const TStringBuf input, EKeyRing ring) const;

    private:
        const TKeyRingHolderWithDefaultKey& GetKeyRing(EKeyRing ring) const;

        TKeyRingMap KeyRingMap_;
    };
}
