#pragma once

#include "processor.h"

#include <passport/infra/libs/cpp/hbase/batch.h>
#include <passport/infra/libs/cpp/hbase/hbase_pool.h>
#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/logbroker/pusher/base_pusher.h>
#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/yt/batch.h>

#include <memory>

namespace NPassport::NLbchdb {
    using TLbReaderPool = NLb::TReaderPool<TQueries, ELogType>;
    using TLbReaderPoolPtr = NLb::TReaderPoolPtr<TQueries, ELogType>;

    struct TPusherSettings {
        NUnistat::TTimeStat::TBounds HbaseTimeStatBounds;
        TDuration YtMaxTimeSignal = TDuration::Seconds(10);
    };

    struct TPusherWorkerSettings {
        std::optional<NHbase::TSettings> Hbase;
        NHbase::TBatch::TSettings HbaseBatch;
        TString HbaseTablesPrefix;

        NYt::TBatchSettings YtBatch;
        NYt::TYtClientFactoryPtr YtFactory;

        NLb::NPusher::TBaseWorkerSettings Base;
    };

    class TDataPusher: public NLb::NPusher::TBasePusher<TDataPusher, TQueries, ELogType> {
        using TBase = NLb::NPusher::TBasePusher<TDataPusher, TQueries, ELogType>;

    public:
        TDataPusher(TPusherSettings settings, TLbReaderPoolPtr readerPool);
        ~TDataPusher();

        void AddUnistat(NUnistat::TBuilder& builder);

    public:
        struct TUnistat {
            NUnistat::TSignalDiff<> HbaseRequests = {"hbase.succeed.requests"};
            NUnistat::TSignalDiff<> HbaseBatches = {"hbase.succeed.batches"};
            NUnistat::TSignalDiff<> HbaseMutations = {"hbase.succeed.mutations"};
            NUnistat::TSignalDiff<> HbaseErrors = {"hbase.failes"};
            std::shared_ptr<NUnistat::TTimeStat> HbaseTimeStats;

            NUnistat::TSignalDiff<> YtRequests = {"yt.requests"};
            NUnistat::TSignalDiff<> YtWrittenRows = {"yt.written_rows"};
            NUnistat::TSignalDiff<> YtErrors = {"yt.failes"};
            std::shared_ptr<NUnistat::TTimeStat> YtTimeStats;
        } Unistat;
    };

    class TDataPushWorker: public NLb::NPusher::TBaseWorker<TDataPusher> {
        using TBase = NLb::NPusher::TBaseWorker<TDataPusher>;

    public:
        TDataPushWorker(const TPusherWorkerSettings& settings, size_t idx, TDataPusher& parent);

        bool Proc(TLbReaderPool::TParsedData& data);

    private:
        std::unique_ptr<NHbase::THBasePool> Hbase_;
        NHbase::TBatch::TSettings HbaseBatchSettings_;
        const std::string HbaseTablesPrefix_;

        NYt::TBatchSettings YtBatchSettings_;
        NYt::TYtClient YtClient_;
    };

    using TDataPusherPtr = std::unique_ptr<TDataPusher>;

    class TErrIncrementer {
    public:
        TErrIncrementer(NUnistat::TSignalDiff<>& sig);
        ~TErrIncrementer();

        void Clear() {
            Sig_ = nullptr;
        }

    private:
        NUnistat::TSignalDiff<>* Sig_;
    };
}
