#include "ipreg.h"

#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/file.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/deprecated/ipreg1/lookup.h>

namespace NPassport::NLbchdb {
    TIpReg::TIpReg(const TString& filename) {
        Loader_ = std::make_unique<NUtils::TFileLoader>(
            filename,
            [this](const TString& filename) {
                Lookup_.Set(std::make_shared<NIpreg::TLookup>(filename.c_str()));
            },
            TDuration::Minutes(1));
    }

    TIpReg::~TIpReg() = default;

    IIpReg::TIpInfo TIpReg::GetIpInfo(const TString& ip) const {
        try {
            NIpreg::Net net = Lookup_.Get()->GetNet(ip);
            return {
                .IsYandex = net.IsYandex,
                .IsUser = net.IsUser,
            };
        } catch (const std::exception& e) {
            ++UnistatErrors_;
            TLog::Debug() << "Failed to get info from ipreg: " << ip
                          << ". " << e.what();
        }

        return {};
    }

    void TIpReg::AddUnistat(NUnistat::TBuilder& builder) const {
        builder.Add(UnistatErrors_);
    }
}
