#pragma once

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <util/generic/string.h>

#include <optional>

namespace NIpreg {
    class TLookup;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NUtils {
    class TFileLoader;
}

namespace NPassport::NLbchdb {
    class IIpReg {
    public:
        struct TIpInfo {
            bool IsYandex = false;
            bool IsUser = false;
        };

        virtual ~IIpReg() = default;
        virtual TIpInfo GetIpInfo(const TString& ip) const = 0;

        virtual void AddUnistat(NUnistat::TBuilder&) const {
        }
    };

    using TIpRegPtr = std::unique_ptr<IIpReg>;

    class TIpReg: public IIpReg {
    public:
        TIpReg(const TString& filename);
        ~TIpReg() override;

        TIpInfo GetIpInfo(const TString& ip) const override;

        void AddUnistat(NUnistat::TBuilder& builder) const override;

    private:
        NUtils::TSharedState<NIpreg::TLookup> Lookup_;
        mutable NUnistat::TSignalDiff<> UnistatErrors_ = {"depends.ipreg.error"};

        // must be last
        std::unique_ptr<NUtils::TFileLoader> Loader_;
    };
}
