#include "uatraits.h"

#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/file.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/user_agent/browser_detector.h>

namespace NPassport::NLbchdb {
    static NUserAgent::TBrowserDetector& GetInstanse() {
        return NUserAgent::TBrowserDetector::Instance();
    }

    TUaTraits::TUaTraits(const TString& filename) {
        Loader_ = std::make_unique<NUtils::TFileLoader>(
            filename,
            [this](const TStringBuf filebody, time_t) {
                std::unique_lock lock(Mutex_);
                Y_ENSURE(GetInstanse().InitializeUatraitsFromMemory(filebody),
                         "failed to initialize uatraits");
            },
            TDuration::Minutes(1));
    }

    TUaTraits::~TUaTraits() = default;

    std::optional<IUaTraits::TData> TUaTraits::GetUaData(const TString& userAgent) const {
        try {
            IUaTraits::TData res;

            {
                std::shared_lock lock(Mutex_);
                res.Data = GetInstanse().GetUatraitsData(userAgent);
            }

            Filter(res.Data);
            return res;
        } catch (const std::exception& e) {
            ++UnistatErrors_;
            TLog::Error() << "Exception in uatraits for ua '" << userAgent << "': " << e.what();
        }

        return {};
    }

    void TUaTraits::AddUnistat(NUnistat::TBuilder& builder) const {
        builder.Add(UnistatErrors_);
    }

    void TUaTraits::Filter(IUaTraits::TData::TMap& data) {
        for (auto it = data.begin(); it != data.end();) {
            if (it->second.empty() || "Unknown" == it->second) {
                data.erase(it++);
                continue;
            }

            ++it;
        }
    }
}
