#pragma once

#include <passport/infra/libs/cpp/unistat/diff.h>

#include <util/generic/string.h>

#include <map>
#include <memory>
#include <optional>
#include <shared_mutex>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NUtils {
    class TFileLoader;
}

namespace NPassport::NLbchdb {
    class IUaTraits {
    public:
        struct TData {
            using TMap = std::map<std::string, std::string>;
            TMap Data;
        };

        virtual ~IUaTraits() = default;
        virtual std::optional<TData> GetUaData(const TString& userAgent) const = 0;

        virtual void AddUnistat(NUnistat::TBuilder&) const {
        }
    };

    using TUaTraitsPtr = std::unique_ptr<IUaTraits>;

    class TUaTraits: public IUaTraits {
    public:
        TUaTraits(const TString& filename);
        ~TUaTraits() override;

        std::optional<TData> GetUaData(const TString& userAgent) const override;

        void AddUnistat(NUnistat::TBuilder& builder) const override;

        static void Filter(IUaTraits::TData::TMap& data);

    private:
        mutable NUnistat::TSignalDiff<> UnistatErrors_ = {"depends.uatraits.error"};
        mutable std::shared_mutex Mutex_;

        // must be last
        std::unique_ptr<NUtils::TFileLoader> Loader_;
    };
}
