#include "auth_extender.h"

namespace NPassport::NLbchdb::NExtend {
    TAuthExtender::TAuthExtender(const NGeobase::IGeobase& geobase,
                                 const IIpReg& ipreg,
                                 const IUaTraits& uatraits)
        : Geobase_(geobase)
        , Ipreg_(ipreg)
        , Uatraits_(uatraits)
    {
    }

    TAuthExtendedEntry TAuthExtender::Process(NParser::TAuthRow&& r) {
        TAuthExtendedEntry res;

        res.Row = std::move(r);
        res.IpData = TIpData::Create(Geobase_, Ipreg_, TIpData::ChooseUserIp(res.Row));
        res.UaData = TUserAgentData::Create(Uatraits_, res.Row.UserAgent);
        res.Comment = TComment::Create(res.Row.Comment);
        res.Laas = TLaasInfo::Create(res.Comment.Get(TComment::EKey::Pos));

        return res;
    }
}
