#pragma once

#include "utils.h"

#include <passport/infra/daemons/lbchdb/src/parsers/auth_parser.h>

namespace NPassport::NLbchdb::NExtend {
    struct TAuthExtendedEntry { // NOLINT(bugprone-exception-escape)
        NParser::TAuthRow Row;
        std::optional<TIpData> IpData;
        std::optional<TUserAgentData> UaData;
        TComment Comment;
        std::optional<TLaasInfo> Laas;
    };

    class TAuthExtender {
    public:
        using TResult = std::vector<TAuthExtendedEntry>;

        TAuthExtender(const NGeobase::IGeobase& geobase,
                      const IIpReg& ipreg,
                      const IUaTraits& uatraits);

        TAuthExtendedEntry Process(NParser::TAuthRow&& row);

    private:
        const NGeobase::IGeobase& Geobase_;
        const IIpReg& Ipreg_;
        const IUaTraits& Uatraits_;
    };
}
