#include "event_extender.h"

namespace NPassport::NLbchdb::NExtend {
    bool TEventExtendedEntry::operator==(const TEventExtendedEntry& o) const {
        return Row == o.Row && IpData == o.IpData;
    }

    TEventExtender::TEventExtender(const NGeobase::IGeobase& geobase, const IIpReg& ipreg)
        : Geobase_(geobase)
        , Ipreg_(ipreg)
    {
    }

    TEventExtendedEntry TEventExtender::Process(NParser::TEventRow&& row) const {
        TEventExtendedEntry entry;

        entry.Row = std::move(row);
        if (entry.Row.ProxyIp || entry.Row.UserIp) {
            entry.IpData = TIpData::Create(Geobase_, Ipreg_, TIpData::ChooseUserIp(entry.Row));
        }

        entry.Row.UserIp.SkipPrefix("::ffff:");
        entry.Row.ProxyIp.SkipPrefix("::ffff:");

        return entry;
    }
}
