#pragma once

#include "utils.h"

#include <passport/infra/daemons/lbchdb/src/parsers/event_parser.h>

namespace NPassport::NLbchdb::NExtend {
    struct TEventExtendedEntry {
        NParser::TEventRow Row;
        std::optional<TIpData> IpData;

        bool operator==(const TEventExtendedEntry& o) const;
    };

    class TEventExtender {
    public:
        using TResult = std::vector<TAuthExtendedEntry>;

        TEventExtender(const NGeobase::IGeobase& geobase,
                       const IIpReg& ipreg);

        TEventExtendedEntry Process(NParser::TEventRow&& row) const;

    private:
        const NGeobase::IGeobase& Geobase_;
        const IIpReg& Ipreg_;
    };
}
