#include "oauth_extender.h"

namespace NPassport::NLbchdb::NExtend {
    TOAuthExtender::TOAuthExtender(const NGeobase::IGeobase& geobase, const IIpReg& ipreg)
        : Geobase_(geobase)
        , Ipreg_(ipreg)
    {
    }

    TOAuthExtendedEntry TOAuthExtender::Process(NParser::TOAuthRow&& row) {
        TOAuthExtendedEntry res;

        res.Row = std::move(row);
        res.IpData = TIpData::Create(Geobase_, Ipreg_, TString(res.Row.UserIp));

        return res;
    }

    bool TOAuthExtendedEntry::operator==(const TOAuthExtendedEntry& o) const {
        return Row == o.Row &&
               IpData == o.IpData;
    }
}
