#pragma once

#include "utils.h"

#include <passport/infra/daemons/lbchdb/src/parsers/oauth_parser.h>

namespace NPassport::NLbchdb::NExtend {
    struct TOAuthExtendedEntry {
        NParser::TOAuthRow Row;
        std::optional<TIpData> IpData;

        bool operator==(const TOAuthExtendedEntry& o) const;
    };

    class TOAuthExtender {
    public:
        using TResult = std::vector<TOAuthExtendedEntry>;

        TOAuthExtender(const NGeobase::IGeobase& geobase,
                       const IIpReg& ipreg);

        TOAuthExtendedEntry Process(NParser::TOAuthRow&& row);

    private:
        const NGeobase::IGeobase& Geobase_;
        const IIpReg& Ipreg_;
    };
}
