#pragma once

#include <passport/infra/daemons/lbchdb/src/depends/ipreg.h>
#include <passport/infra/daemons/lbchdb/src/depends/uatraits.h>

#include <passport/infra/libs/cpp/geobase/geobase.h>

#include <array>

namespace NPassport::NUtils {
    class TIpAddr;
}

namespace NPassport::NLbchdb::NExtend {
    bool IsRealUserIp(const NUtils::TIpAddr& ip);
    bool IsYandexIp(IIpReg::TIpInfo net);

    struct TIpData {
        std::optional<ui32> GeoId;
        std::optional<std::string> As;
        TString Packed;
        TString PackedShortest;
        std::string Unpacked;
        bool IsReal = false;
        bool IsYandex = false;

        static std::optional<TIpData> Create(const NGeobase::IGeobase& geobase,
                                             const IIpReg& ipreg,
                                             const std::string& ip);

        template <class Row>
        static std::string ChooseUserIp(const Row& row) {
            return std::string(row.ProxyIp ? row.ProxyIp : row.UserIp);
        }

        bool operator==(const TIpData& o) const;
    };

    struct TUserAgentData {
        std::string BrowserName;
        std::string BrowserVersion;
        std::string OsName;
        std::string OsFamily;
        std::string OsVersion;

        static std::optional<TUserAgentData> Create(const IUaTraits& uatraits, const TString& ua);
        bool operator==(const TUserAgentData& o) const;
    };

    struct TComment {
        enum class EKey {
            TokenId,
            ClientId,
            DeviceId,
            DeviceName,
            Scope,
            ApplicationPassword,
            ASrc,
            Pos,

            Count,
        };

        static TComment Create(TStringBuf comment);
        TStringBuf Get(EKey key) const;

        TString PrintDebug() const;
        bool operator==(const TComment& o) const;

    private:
        std::array<TStringBuf, (int)EKey::Count> Values_;
    };

    struct TLaasInfo {
        double Latitude = 0.;
        double Longitude = 0.;
        ui64 Accuracy = 0;
        TString Precision;

        static std::optional<TLaasInfo> Create(TStringBuf pos);
        TString ToString() const;
        bool operator==(const TLaasInfo& o) const;
    };
}
