#include "aggregate_auth_helper.h"

#include <passport/infra/daemons/lbchdb/src/proto/auths.pb.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/string/builder.h>

namespace NPassport::NLbchdb::NHBaseConv {
    bool TAggregateAuthHelper::IsEntryWriteable(const std::optional<NExtend::TIpData>& ipData) {
        if (!ipData) {
            return false;
        }

        const NExtend::TIpData& ip = *ipData;

        return !ip.Unpacked.empty() &&
               ip.Packed &&
               !ip.IsYandex &&
               ip.IsReal;
    }

    void TAggregateAuthHelper::FillIpInfo(const NExtend::TIpData& data, AuthInfo& proto) {
        IPInfo* info = proto.mutable_ip_info();

        info->set_ip(data.Packed);

        if (data.GeoId) {
            info->set_geoid(*data.GeoId);
        }

        if (data.As) {
            TStringBuf AS = *data.As;
            AS.Skip(2);
            ui64 as = 0;
            if (AS && TryIntFromString<10>(AS, as)) {
                info->set_as(as);
            }
        }
    }

    TString TAggregateAuthHelper::BuildRow(ui64 uid, TInstant timestamp, TStringBuf tail) {
        TString res = NUtils::CreateStr(
            TStringBuilder() << LeftPad(uid % 1000, 3, '0'),
            "00000000", // dummy placeholder#1 for uid
            "0000",     // dummy placeholder#2 for hours
            tail);

        // replace placeholder#1
        NUtils::ToBytesMsb(uid, res, 3);

        // replace placeholder#2
        ui32 hours = timestamp.TimeT() / 3600;
        NUtils::ToBytesMsb(std::numeric_limits<ui32>::max() - hours, res, 11);

        return res;
    }
}
