#include "failed_auths.h"

#include "auths.h"

#include <passport/infra/daemons/lbchdb/src/helpers/auths_helper.h>

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/generic/hash_set.h>

namespace NPassport::NLbchdb::NHBaseConv::NAuth {
    const std::string TFailedAuthQuery::TABLE_NAME = "failed_auths";

    NHbase::TQuery TFailedAuthQuery::BuildQuery(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled) {
        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = TFailedAuthQuery::BuildRow(entry, isSamplingEnabled);
        TAuthQuery::BuildParams(entry, res);

        return res;
    }

    TString TFailedAuthQuery::BuildRow(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled) {
        // https://a.yandex-team.ru/arc/trunk/arcadia/passport/python/library/historydbloader/historydb/hbase_converter.py?rev=5699294#L174
        // build_failed_auth_row
        TString res = NUtils::CreateStrExt(
            128,
            entry.Row.Uid,
            "_",
            TAuthQuery::BuildReverseTimestamp(entry.Row.Timestamp),
            "_");

        NHelpers::TAuthsHelper::BuildKeyUniquePart(entry, isSamplingEnabled, res);

        return res;
    }
}
