#include "last_auth.h"

#include <passport/infra/daemons/lbchdb/src/hbase_converters/utils.h>

#include <passport/infra/daemons/lbchdb/src/helpers/auths_helper.h>

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/stream/format.h>
#include <util/string/cast.h>

namespace NPassport::NLbchdb::NHBaseConv::NAuth {
    const std::string TLastAuth::TABLE_NAME = "lastauth";
    /// table 'lastauth': family: "c"
    /// columns already prepared for params
    static const std::string LASTAUTH_COLUMN_LASTAUTH = "c:lastauth";
    static const std::string LASTAUTH_COLUMN_TYPE = "c:type";

    std::optional<NHbase::TQuery> TLastAuth::BuildQuery(const NExtend::TAuthExtendedEntry& entry) {
        if (!NHelpers::TAuthsHelper::IsSuccessAuth(entry.Row, true)) {
            return {};
        }

        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = IntToString<10>(entry.Row.Uid);

        res.AddParam(LASTAUTH_COLUMN_LASTAUTH, TUtils::PrintTimeInPythonStyle(entry.Row.Timestamp));
        res.AddParam(LASTAUTH_COLUMN_TYPE, entry.Row.AuthType);

        return res;
    }
}
