#include "oauth.h"

#include <passport/infra/daemons/lbchdb/src/hbase_converters/aggregate_auth_helper.h>

#include <passport/infra/daemons/lbchdb/src/proto/auths.pb.h>

#include <library/cpp/string_utils/quote/quote.h>

namespace NPassport::NLbchdb::NHBaseConv::NAuth {
    static const TString OAUTH_TOKEN_BY_PASSWORD = "password-oauth";
    const TStringBuf TOAuth::TABLE_NAME = "success_auths_uids_by_hour";

    static void FillTokenInfo(const NExtend::TOAuthExtendedEntry& entry, AuthInfo& info) {
        TokenInfo* tokenInfo = info.mutable_token_info();
        tokenInfo->set_client_id(TString(entry.Row.ClientId));
        tokenInfo->set_token_id(TString(entry.Row.TokenId));

        if (entry.Row.DeviceId) {
            tokenInfo->set_device_id(UrlUnescapeRet(entry.Row.DeviceId));
        }

        if (entry.Row.DeviceName) {
            tokenInfo->set_device_name(UrlUnescapeRet(entry.Row.DeviceName));
        }

        if (entry.Row.Scopes) {
            tokenInfo->set_scopes(TString(entry.Row.Scopes));
        }
    }

    std::optional<NHbase::TQuery> TOAuth::BuildQuery(const NExtend::TOAuthExtendedEntry& entry) {
        // isEntryWriteable checks the same thing, but optional dereference may fail,
        // if that condition is ever removed
        if (!entry.IpData || !entry.Row.ClientId || !entry.Row.TokenId) {
            return {};
        }

        if (!TAggregateAuthHelper::IsEntryWriteable(entry.IpData)) {
            return {};
        }

        NHbase::TQuery query;
        query.Row = TAggregateAuthHelper::BuildRow(entry.Row.Uid, entry.Row.Timestamp, OAUTH_TOKEN_BY_PASSWORD);
        AuthInfo info;
        info.set_type(OAUTH_TOKEN_BY_PASSWORD);
        TAggregateAuthHelper::FillIpInfo(*entry.IpData, info);
        FillTokenInfo(entry, info);

        TString key = NUtils::CreateStr("i:", info.SerializeAsString());
        TString timestamp = FloatToString(entry.Row.Timestamp.SecondsFloat(), EFloatToStringMode::PREC_POINT_DIGITS_STRIP_ZEROES, 2);

        if (!TStringBuf(timestamp).Tail(3).Contains('.')) {
            timestamp += ".0";
        }

        query.AddParam(TStringBuf(key), TStringBuf(timestamp));

        return query;
    }
}
