#include "auth_converter.h"

#include "auth/auths.h"
#include "auth/failed_auths.h"
#include "auth/last_auth.h"
#include "auth/succed_auths.h"

#include <passport/infra/daemons/lbchdb/src/helpers/auths_helper.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NLbchdb::NHBaseConv {
    void TAuthConverter::Reserve(size_t size) {
        for (NHbase::TQueryArray& a : Tables_) {
            a.reserve(size);
        }
    }

    void TAuthConverter::ProcessCommon(const NExtend::TAuthExtendedEntry& entry, bool isLastauthEnabled) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        auto add = [](NHbase::TQueryArray& arr, std::optional<NHbase::TQuery>&& q) {
            if (q) {
                arr.push_back(std::move(*q));
            }
        };

        if (isLastauthEnabled) {
            add(Tables_[ETable::LastAuth], NAuth::TLastAuth::BuildQuery(entry));
        }
        add(Tables_[ETable::SuccessAuth], NAuth::TSuccessAuth::BuildQuery(entry));
    }

    void TAuthConverter::ProcessSampled(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        if (NHelpers::TAuthsHelper::IsFailedAuthStatus(entry.Row.Status)) {
            Tables_[ETable::FailedAuths].emplace_back(NAuth::TFailedAuthQuery::BuildQuery(entry, isSamplingEnabled));
        } else {
            Tables_[ETable::Auths].emplace_back(NAuth::TAuthQuery::BuildQuery(entry, isSamplingEnabled));
        }
    }

    NHbase::TQueries TAuthConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        IsFinished_ = true;

        NHbase::TQueries res;
        res.ByTable.emplace(NAuth::TAuthQuery::TABLE_NAME, std::move(Tables_[ETable::Auths]));
        res.ByTable.emplace(NAuth::TFailedAuthQuery::TABLE_NAME, std::move(Tables_[ETable::FailedAuths]));
        res.ByTable.emplace(NAuth::TLastAuth::TABLE_NAME, std::move(Tables_[ETable::LastAuth]));
        res.ByTable.emplace(NAuth::TSuccessAuth::TABLE_NAME, std::move(Tables_[ETable::SuccessAuth]));

        return res;
    }
}
