#pragma once

#include <passport/infra/daemons/lbchdb/src/extenders/auth_extender.h>

#include <passport/infra/libs/cpp/hbase/query.h>

#include <unordered_map>

namespace NPassport::NLbchdb::NHBaseConv {
    class TAuthConverter: TMoveOnly {
    public:
        enum ETable {
            Auths,
            FailedAuths,
            LastAuth,
            SuccessAuth,

            COUNT,
        };

        TAuthConverter() = default;

        void Reserve(size_t size);
        void ProcessCommon(const NExtend::TAuthExtendedEntry& entry, bool isLastauthEnabled);
        void ProcessSampled(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled);
        NHbase::TQueries Finish();

    private:
        std::array<NHbase::TQueryArray, ETable::COUNT> Tables_;
        bool IsFinished_ = false;
    };
}
