#include "event_converter.h"

#include "events/event.h"
#include "events/registration.h"

namespace NPassport::NLbchdb::NHBaseConv {
    void TEventConverter::Reserve(size_t size) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        for (NHbase::TQueryArray& a : Tables_) {
            a.reserve(size);
        }
    }

    void TEventConverter::Process(NExtend::TEventExtendedEntry&& entry) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        std::optional<NHbase::TQuery> query = NEvent::TEvent::BuildQuery(entry);
        if (query) {
            Tables_[ETable::Event].push_back(std::move(*query));
        }

        query = NEvent::TRegistration::BuildQuery(entry);
        if (query) {
            Tables_[ETable::Registration].push_back(std::move(*query));
        }
    }

    NHbase::TQueries TEventConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");
        IsFinished_ = true;

        NHbase::TQueries res;
        res.ByTable.emplace(NEvent::TEvent::TABLE_NAME, std::move(Tables_[ETable::Event]));
        res.ByTable.emplace(NEvent::TRegistration::TABLE_NAME, std::move(Tables_[ETable::Registration]));

        return res;
    }
}
