#pragma once

#include "events/event.h"

#include <passport/infra/daemons/lbchdb/src/extenders/event_extender.h>

#include <passport/infra/libs/cpp/hbase/query.h>

namespace NPassport::NLbchdb::NHBaseConv {
    class TEventConverter: TMoveOnly {
    public:
        enum ETable {
            Event,
            Registration,

            COUNT,
        };

        TEventConverter() = default;

        void Reserve(size_t size);
        void Process(NExtend::TEventExtendedEntry&& entry);
        NHbase::TQueries Finish();

    private:
        std::array<NHbase::TQueryArray, ETable::COUNT> Tables_;

        bool IsFinished_ = false;
    };
}
