#include "common.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/string/subst.h>

namespace NPassport::NLbchdb::NHBaseConv::NEvent {
    const ui32 TBaseEventConverter::EVENTS_KEY_TIMESTAMP_MS_LIMIT = 1000000;

    TString TBaseEventConverter::BuildKeyUniquePart(const NParser::TBaseEventRow& entry) {
        TString name = entry.Name.value_or("-");
        SubstGlobal(name, '_', '-');

        TString hostId = entry.HostId ? IntToString<10, ui64>(*entry.HostId) : "-";

        return NUtils::CreateStr(entry.Uid, '_', BuildReverseTs(entry.Timestamp), "_", hostId, ".", name);
    }

    TString TBaseEventConverter::BuildReverseTs(TInstant timestamp) {
        char ts[64];
        size_t length = std::snprintf(ts, sizeof(ts), "%019lu.%06u",
                                      std::numeric_limits<i64>::max() - timestamp.Seconds(),
                                      EVENTS_KEY_TIMESTAMP_MS_LIMIT - ui32(timestamp.MicroSecondsOfSecond()));
        return TString(ts, length);
    }
}
