#include "event.h"

namespace NPassport::NLbchdb::NHBaseConv::NEvent {
    const TStringBuf TEvent::COLUMN_UID = "c:uid";
    const TStringBuf TEvent::COLUMN_HOST_ID = "c:host_id";
    const TStringBuf TEvent::COLUMN_CLIENT_NAME = "c:client_name";
    const TStringBuf TEvent::COLUMN_NAME = "c:name";
    const TStringBuf TEvent::COLUMN_VALUE = "c:value";
    const TStringBuf TEvent::COLUMN_YANDEX_UID = "c:yandexuid";
    const TStringBuf TEvent::COLUMN_ADMIN = "c:admin";
    const TStringBuf TEvent::COLUMN_COMMENT = "c:comment";
    const TStringBuf TEvent::COLUMN_USER_IP = "c:user_ip";
    const TStringBuf TEvent::COLUMN_GEO_ID = "c:ip.geoid";
    const TStringBuf TEvent::COLUMN_AS_LIST = "c:ip.as_list";
    const TStringBuf TEvent::COLUMN_IS_YANDEX = "c:ip.is_yandex";

    const TStringBuf TEvent::TABLE_NAME = "events";

    std::optional<NHbase::TQuery> TEvent::BuildQuery(const NExtend::TEventExtendedEntry& entry) {
        NHbase::TQuery query;

        query.Row = BuildKeyUniquePart(entry.Row);
        PopulateOptionalFields(entry, query);

        query.AddParam(COLUMN_USER_IP, NExtend::TIpData::ChooseUserIp(entry.Row));
        if (entry.IpData) {
            AddOptionalParam(query, COLUMN_GEO_ID, entry.IpData->GeoId);
            AddOptionalParam(query, COLUMN_AS_LIST, entry.IpData->As);
            if (entry.IpData->IsYandex) {
                query.AddParam(COLUMN_IS_YANDEX, TStringBuf("1"));
            }
        }

        return query;
    }

    void TEvent::PopulateOptionalFields(const NExtend::TEventExtendedEntry& entry, NHbase::TQuery& query) {
        AddOptionalParam(query, COLUMN_HOST_ID, entry.Row.HostId);
        AddOptionalParam(query, COLUMN_CLIENT_NAME, entry.Row.ClientName);
        AddOptionalParam(query, COLUMN_NAME, entry.Row.Name);
        AddOptionalParam(query, COLUMN_VALUE, entry.Row.EventValue);
        AddOptionalParam(query, COLUMN_YANDEX_UID, entry.Row.YandexUid);
        AddOptionalParam(query, COLUMN_ADMIN, entry.Row.AdminLogin);
        AddOptionalParam(query, COLUMN_COMMENT, entry.Row.Comment);
    }

    void TEvent::AddOptionalParam(NHbase::TQuery& query, TStringBuf column, ui64 value) {
        query.AddParam(column, TStringBuf(IntToString<10>(value)));
    }

    void TEvent::AddOptionalParam(NHbase::TQuery& query, TStringBuf column, TStringBuf data) {
        if (data) {
            query.AddParam(column, data);
        }
    }

    template <class T>
    void TEvent::AddOptionalParam(NHbase::TQuery& query, TStringBuf column, std::optional<T> data) {
        if (data) {
            AddOptionalParam(query, column, *data);
        }
    }

}
