#pragma once

#include "common.h"

#include <passport/infra/daemons/lbchdb/src/extenders/event_extender.h>

#include <passport/infra/libs/cpp/hbase/query.h>

namespace NPassport::NLbchdb::NHBaseConv::NEvent {
    class TEvent: public TBaseEventConverter {
    public:
        static std::optional<NHbase::TQuery> BuildQuery(const NExtend::TEventExtendedEntry& entry);

        static const TStringBuf TABLE_NAME;

    protected:
        static const TStringBuf COLUMN_UID;
        static const TStringBuf COLUMN_HOST_ID;
        static const TStringBuf COLUMN_CLIENT_NAME;
        static const TStringBuf COLUMN_NAME;
        static const TStringBuf COLUMN_VALUE;
        static const TStringBuf COLUMN_YANDEX_UID;
        static const TStringBuf COLUMN_ADMIN;
        static const TStringBuf COLUMN_COMMENT;
        static const TStringBuf COLUMN_USER_IP;
        static const TStringBuf COLUMN_GEO_ID;
        static const TStringBuf COLUMN_AS_LIST;
        static const TStringBuf COLUMN_IS_YANDEX;

        static void AddOptionalParam(NHbase::TQuery& query, TStringBuf column, ui64 value);

        static void AddOptionalParam(NHbase::TQuery& query, TStringBuf column, TStringBuf data);

        template <class T>
        static void AddOptionalParam(NHbase::TQuery& query, TStringBuf column, std::optional<T> data);

        static void PopulateOptionalFields(const NExtend::TEventExtendedEntry& entry, NHbase::TQuery& query);
    };
}
