#include "restore_events.h"

namespace NPassport::NLbchdb::NHBaseConv::NEvent {
    static const std::string TABLE_NAME = "events";

    static const std::string COLUMN_RESTORE_ID = "r:restore_id";
    static const std::string COLUMN_ACTION = "r:action";
    static const std::string COLUMN_DATA_JSON = "r:data_json";

    std::optional<NHbase::TQuery> TRestoreEvent::BuildQuery(const NParser::TRestoreRow& entry) {
        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = BuildKeyUniquePart(entry);

        res.AddParam(COLUMN_RESTORE_ID, entry.RestoreId);
        res.AddParam(COLUMN_ACTION, entry.Action);
        res.AddParam(COLUMN_DATA_JSON, TStringBuf(entry.DataJson));

        return res;
    }
}
