#include "users_history.h"

#include <util/generic/hash_set.h>
#include <util/string/builder.h>

namespace NPassport::NLbchdb::NHBaseConv::NMailUserJournal {
    const std::string TUsersHistory::TABLE_NAME = "users_history";
    const std::string TUsersHistory::CORP_TABLE_NAME = "corp_users_history";

    const size_t MAX_FIELD_LENGTH = 1000;

    std::optional<NHbase::TQuery> TUsersHistory::BuildQuery(const NParser::TMailUserJournalRow& entry) {
        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = BuildRow(entry);

        for (const auto& [key, value] : entry.Tskv.Fields()) {
            if (IgnoreField(key) || value.empty()) {
                continue;
            }
            std::string column("cf:");
            column.append(key);
            res.AddParam(std::move(column), value.Head(MAX_FIELD_LENGTH));
        }

        return res;
    }

    static const THashSet<TString> FIELDS_TO_STORE = {
        "abuseType",
        "affected",
        "browser.name",
        "browser.version",
        "condition",
        "destFid",
        "deviceType",
        "emailFrom",
        "fid",
        "filterIds",
        "folder_symbol",
        "ftype",
        "hidden",
        "internetProvider",
        "ip",
        "lids",
        "lidText",
        "mid",
        "module",
        "msgStatus",
        "operation",
        "operationSystem.name",
        "operationSystem.version",
        "regionId",
        "spam_type",
        "state",
        "target",
        "unixtime",
        "view_date",
    };

    bool TUsersHistory::IgnoreField(TStringBuf field) {
        return !FIELDS_TO_STORE.contains(field);
    }

    // https://a.yandex-team.ru/arc/trunk/arcadia/passport/python/library/historydbloader/historydb/hbase_converter.py?rev=5699294#L272
    TString TUsersHistory::BuildRow(const NParser::TMailUserJournalRow& entry) {
        ui64 reverse_ts = std::numeric_limits<ui64>::max() - entry.Date + 1;
        return TStringBuilder() << entry.Uid << '_' << LeftPad(reverse_ts, 20, '0') << '_' << entry.GetField("operation");
    }
}
