#include "mail_user_journal_converter.h"

#include "mail_user_journal/users_history.h"

namespace NPassport::NLbchdb::NHBaseConv {
    void TMailUserJournalConverter::Reserve(size_t size) {
        for (NHbase::TQueryArray& a : Tables_) {
            a.reserve(size);
        }
    }

    void TMailUserJournalConverter::Process(const NParser::TMailUserJournalRow& entry) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        bool isCorp = entry.GetField("tableName") == "corp_users_history";

        auto add = [](NHbase::TQueryArray& arr, std::optional<NHbase::TQuery>&& q) {
            if (q) {
                arr.push_back(std::move(*q));
            }
        };

        add(Tables_[isCorp ? ETable::CorpUsersHistory : ETable::UsersHistory], NMailUserJournal::TUsersHistory::BuildQuery(entry));
    }

    NHbase::TQueries TMailUserJournalConverter::Finish() {
        NHbase::TQueries res;
        auto add = [&](const auto& tableName, ETable tableType) {
            if (!Tables_[tableType].empty()) {
                res.ByTable.emplace(tableName, std::move(Tables_[tableType]));
            }
        };

        add(NMailUserJournal::TUsersHistory::TABLE_NAME, ETable::UsersHistory);
        add(NMailUserJournal::TUsersHistory::CORP_TABLE_NAME, ETable::CorpUsersHistory);

        return res;
    }
}
