#pragma once

#include <passport/infra/daemons/lbchdb/src/parsers/mail_user_journal_parser.h>

#include <passport/infra/libs/cpp/hbase/query.h>

namespace NPassport::NLbchdb::NHBaseConv {
    class TMailUserJournalConverter: TMoveOnly {
    public:
        enum ETable {
            UsersHistory,
            CorpUsersHistory,

            COUNT,
        };

        TMailUserJournalConverter() = default;

        void Reserve(size_t size);
        void Process(const NParser::TMailUserJournalRow& entry);
        NHbase::TQueries Finish();

    private:
        std::array<NHbase::TQueryArray, ETable::COUNT> Tables_;
        bool IsFinished_ = false;
    };
}
