#include "oauth_converter.h"

#include "auth/oauth.h"

namespace NPassport::NLbchdb::NHBaseConv {
    void TOAuthConverter::Reserve(size_t size) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        Table_.reserve(size);
    }

    void TOAuthConverter::Process(NExtend::TOAuthExtendedEntry&& entry) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        std::optional<NHbase::TQuery> query = NAuth::TOAuth::BuildQuery(entry);
        if (query) {
            Table_.push_back(std::move(*query));
        }
    }

    NHbase::TQueries TOAuthConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        NHbase::TQueries res;
        res.ByTable.emplace(NAuth::TOAuth::TABLE_NAME, std::move(Table_));

        IsFinished_ = true;
        return std::move(res);
    }
}
