#include "restore_converter.h"

namespace NPassport::NLbchdb::NHBaseConv {
    void TRestoreConverter::Reserve(size_t size) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        Table_.reserve(size);
    }

    void TRestoreConverter::Process(const NParser::TRestoreRow& entry) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        std::optional<NHbase::TQuery> event = NEvent::TRestoreEvent::BuildQuery(std::move(entry));
        if (event) {
            Table_.push_back(std::move(*event));
        }
    }

    NHbase::TQueries TRestoreConverter::Finish() {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        NHbase::TQueries res;
        res.ByTable.emplace("events", std::move(Table_));

        IsFinished_ = true;
        return std::move(res);
    }
}
