#include "utils.h"

#include <util/stream/format.h>
#include <util/string/cast.h>

#include <array>
#include <string>

namespace NPassport::NLbchdb::NHBaseConv {
    static const std::string TRUE_VALUE = "1";
    static const std::string FALSE_VALUE = "0";

    const std::string& TUtils::AsBool(bool val) {
        return val ? TRUE_VALUE : FALSE_VALUE;
    }

    std::string TUtils::PrintTimeInPythonStyle(TInstant ins) {
        TStringStream res;
        res.Reserve(16);

        time_t sec = ins.TimeT();
        ui64 microsecs = (ins.MicroSecondsOfSecond() + 5000) / 10000;
        if (microsecs >= 100) {
            microsecs -= 100;
            sec += 1;
        }

        res << sec << "." << LeftPad(microsecs, 2, '0');

        if (res.Str().EndsWith('0')) {
            res.Str().pop_back();
        }

        return std::string(res.Str());
    }
}
