#include "yasms_private_converter.h"

#include "yasms_private_converter/yasms_sms_history.h"

namespace NPassport::NLbchdb::NHBaseConv {
    void TYasmsPrivateConverter::Reserve(size_t size) {
        Queries_.reserve(3 * size);
    }

    void TYasmsPrivateConverter::Process(const NParser::TYasmsPrivateRow& entry) {
        Y_VERIFY(!IsFinished_, "Internal error: Converter finished operation");

        auto add = [this](std::optional<NHbase::TQuery>&& q) {
            if (q) {
                Queries_.push_back(std::move(*q));
            }
        };

        Queries_.push_back(NYasmsPrivate::TSmsHistory::BuildSmsHistoryByPhoneQuery(entry));
        Queries_.push_back(NYasmsPrivate::TSmsHistory::BuildGlobalSmsIdToPhoneQuery(entry));
        add(NYasmsPrivate::TSmsHistory::BuildUidToPhoneQuery(entry));
    }

    NHbase::TQueries TYasmsPrivateConverter::Finish() {
        IsFinished_ = true;

        NHbase::TQueries res;
        res.ByTable.emplace(NYasmsPrivate::TSmsHistory::TABLE_NAME, std::move(Queries_));
        return res;
    }
}
