#include "yasms_sms_history.h"

#include <passport/infra/daemons/lbchdb/src/hbase_converters/utils.h>

namespace NPassport::NLbchdb::NHBaseConv::NYasmsPrivate {
    const std::string TSmsHistory::TABLE_NAME = "yasms_sms_history";

    static const std::string COLUMN_FAMILY = "c:";
    static const std::string YASMS_COLUMN_IS_SMS = "c:sms";
    static const std::string YASMS_COLUMN_GLOBAL_SMS_ID = "c:global_smsid";
    static const std::string YASMS_COLUMN_ACTION = "c:action";
    static const std::string YASMS_COLUMN_TIMESTAMP = "c:timestamp";
    static const std::string YASMS_COLUMN_NUMBER = "c:number";
    static const std::string YASMS_COLUMN_UID = "c:uid";
    static const std::string YASMS_COLUMN_TEXT = "c:text";

    NHbase::TQuery TSmsHistory::BuildSmsHistoryByPhoneQuery(const NParser::TYasmsPrivateRow& entry) {
        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = BuildSmsHistoryByPhoneRow(entry);

        BuildParams(entry, res);

        return res;
    }

    NHbase::TQuery TSmsHistory::BuildGlobalSmsIdToPhoneQuery(const NParser::TYasmsPrivateRow& entry) {
        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = BuildGlobalSmsIdToPhoneRow(entry);

        BuildParams(entry, res);

        return res;
    }

    std::optional<NHbase::TQuery> TSmsHistory::BuildUidToPhoneQuery(const NParser::TYasmsPrivateRow& entry) {
        if (entry.Action != "enqueued" ||
            !entry.Uid) {
            return {};
        }

        NHbase::TQuery res;
        res.Type = NHbase::TQuery::EType::Put;
        res.Row = BuildUidToPhoneRow(entry);

        BuildParams(entry, res);

        return res;
    }

    TString TSmsHistory::BuildSmsHistoryByPhoneRow(const NParser::TYasmsPrivateRow& entry) {
        TStringBuf number = entry.Number;
        number.SkipPrefix("+");

        return NUtils::CreateStr(
            "phone:", number,
            ":", entry.GlobalSmsId,
            ":", entry.Timestamp.MicroSeconds(),
            "_", entry.Action);
    }

    TString TSmsHistory::BuildGlobalSmsIdToPhoneRow(const NParser::TYasmsPrivateRow& entry) {
        return NUtils::CreateStr(
            "gsmsid:", entry.GlobalSmsId,
            ":", entry.Timestamp.MicroSeconds(),
            "_", entry.Action);
    }

    TString TSmsHistory::BuildUidToPhoneRow(const NParser::TYasmsPrivateRow& entry) {
        return NUtils::CreateStr(
            "uid:", entry.Uid,
            ":", entry.Timestamp.MicroSeconds(),
            "_", entry.Action);
    }

    void TSmsHistory::BuildParams(const NParser::TYasmsPrivateRow& entry, NHbase::TQuery& q) {
        q.AddParam(YASMS_COLUMN_IS_SMS, TStringBuf("1"));
        q.AddParam(YASMS_COLUMN_GLOBAL_SMS_ID, entry.GlobalSmsId);
        q.AddParam(YASMS_COLUMN_ACTION, entry.Action);
        q.AddParam(YASMS_COLUMN_TIMESTAMP, TUtils::PrintTimeInPythonStyle(entry.Timestamp));
        q.AddParam(YASMS_COLUMN_NUMBER, entry.Number);
        if (entry.Uid) {
            q.AddParam(YASMS_COLUMN_UID, std::to_string(entry.Uid));
        }
        q.AddParam(YASMS_COLUMN_TEXT, TStringBuf(entry.Text));

        for (const auto& [key, value] : entry.ExtraFields()) {
            if (value == "-") {
                continue;
            }

            std::string column(COLUMN_FAMILY);
            column.append(key);
            q.AddParam(std::move(column), value);
        }
    }
}
