#pragma once

#include <passport/infra/daemons/lbchdb/src/extenders/auth_extender.h>
#include <passport/infra/daemons/lbchdb/src/parsers/auth_parser.h>

namespace NPassport::NLbchdb::NHelpers {
    class TAuthsHelper {
    public:
        static bool IsSuccessAuth(const NParser::TAuthRow& row, bool includeSesUpdate);
        static bool IsWebSuccessful(const NParser::TAuthRow& row);

        static bool IsFailedAuthStatus(TStringBuf status);

        static bool IsSampledAuthtype(TStringBuf authtype);
        static TString BuildSamplingKey(const NExtend::TAuthExtendedEntry& entry, ui32 samplingPeriod);

        static TString BuildKeyUniquePart(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled);
        static void BuildKeyUniquePart(const NExtend::TAuthExtendedEntry& entry, bool isSamplingEnabled, TString& out);
    };
}
