#pragma once

#include "data_pusher.h"
#include "depends/ipreg.h"
#include "depends/uatraits.h"

#include <passport/infra/libs/cpp/geobase/geobase.h>
#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/yt/table_creator.h>
#include <passport/infra/libs/cpp/yt/yt_client.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <memory>
#include <vector>

namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLbchdb {
    class TLbchdb {
    public:
        TLbchdb();
        ~TLbchdb();

        void Init(const NJson::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);

        void RotateLogs();

    private:
        void InitLoggers(const NJson::TConfig& config, const TString& path);
        void InitTvm(const NJson::TConfig& config, const TString& path);
        void InitGeobase(const NJson::TConfig& config, const TString& path);
        void InitUaTraits(const NJson::TConfig& config, const TString& path);
        void InitLogbroker(const NJson::TConfig& config, const TString& path);
        static void InitHbase(const NJson::TConfig& config, const TString& path, TPusherWorkerSettings& outSettings);
        void InitYt(const NJson::TConfig& config, const TString& path, TPusherWorkerSettings& outSettings);
        void InitYtTables(const NJson::TConfig& config, const TString& path);
        void InitBlackbox(const NJson::TConfig& config, const TString& path);
        void InitKolmogor(const NJson::TConfig& config, const TString& path);
        void InitDataPusher(const NJson::TConfig& config,
                            const TString& path,
                            const TPusherWorkerSettings& settings);
        void InitProcessor(const NJson::TConfig& config, const TString& path, const TString& createTablesPath);

        void PingKolmogorSpace(const TString& space);

        void HandleHealthCheck(NCommon::TRequest& req);

        void Start();
        void Stop();

    private:
        NYt::TYtClientFactoryPtr YtFactory_; // must be destroyed after stopping operation with YT

        std::vector<std::unique_ptr<NYt::TTableCreator>> TableCreators_;

        TDataPusherPtr DataPusher_;
        TLbReaderPoolPtr Lb_;
        std::shared_ptr<NLb::TResourceDispatcher> UncommittedMemoryDispatcher_;
        std::shared_ptr<NTvmAuth::TTvmClient> Tvm_;
        NGeobase::TGeobasePtr Geobase_;
        TIpRegPtr Ipreg_;
        TUaTraitsPtr Uatraits_;
        TProcessorPtr Processor_;
        std::vector<ELogType> LogTypes_;

        std::shared_ptr<NDbPool::TDbPoolCtx> DbCtx_;
        std::shared_ptr<NDbPool::TDbPool> Kolmogor_;
        std::shared_ptr<NDbPool::TDbPool> Blackbox_;
    };
}
