#pragma once

#include <passport/infra/daemons/lbchdb/src/processor.h>

#include <passport/infra/libs/cpp/logbroker/types.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/csv_row.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/datetime/base.h>

namespace NPassport::NLbchdb::NParser {
    enum class EAuthRow {
        Version,
        Time,
        HostId,
        ClientName,
        Uid,
        Login,
        Sid,
        Type,
        Status,
        Comment,
        UserIp,
        ProxyIp,
        Yandexuid,
        Referer,
        Retpath,
        UserAgent,

        COUNT,
    };

    struct TAuthRow { // NOLINT(bugprone-exception-escape)
        TInstant Timestamp;
        ui64 HostId = 0;
        TStringBuf ClientName;
        ui64 Uid = 0;
        TStringBuf Login;
        TStringBuf Sid;
        TStringBuf AuthType;
        TStringBuf Status;
        TStringBuf Comment;
        TStringBuf UserIp;
        TStringBuf ProxyIp;
        TStringBuf YandexUid;
        TString UserAgent;

        bool TryParse(NRowParsers::TCsvRow&& row);
        bool operator==(const TAuthRow& o) const;

    private:
        // stores allocated strings for TStringBuf above
        NRowParsers::TCsvRow Row_;
    };

    class TAuthParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TAuthRow>;

        explicit TAuthParser(ELogType logType, NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

        static std::optional<TAuthRow> TryParse(TStringBuf line);

    private:
        TResult Result_;
    };
}
