#pragma once

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>

#include <optional>

namespace NPassport::NLbchdb::NParser {
    struct TBaseEventRow {
        TInstant Timestamp;
        ui64 Uid = 0;
        std::optional<TString> Name;
        std::optional<ui32> HostId;

        bool operator==(const TBaseEventRow& o) const {
            return Timestamp == o.Timestamp && Uid == o.Uid && Name == o.Name && HostId == o.HostId;
        }
    };
}
