#pragma once

#include "event_common.h"

#include <passport/infra/daemons/lbchdb/src/processor.h>
#include <passport/infra/daemons/lbchdb/src/crypto/decryptor.h>

#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/csv_row.h>
#include <passport/infra/libs/cpp/utils/ipaddr.h>

#include <util/generic/string.h>

#include <unordered_set>

namespace NPassport::NLbchdb::NParser {
    enum class EEventRow {
        Version,
        RfcTime,
        HostId,
        ClientName,
        Uid,

        EventName,
        EventValue,

        UserIp,
        ProxyIp,
        YandexUid,

        AdminLogin,
        Comment,

        COUNT
    };

    struct TEventRow: TMoveOnly, public TBaseEventRow {
        TStringBuf ClientName;

        TString EventValue;

        TStringBuf UserIp;
        TStringBuf ProxyIp;

        TStringBuf YandexUid;

        TStringBuf AdminLogin;
        TString Comment;

        bool operator==(const TEventRow& o) const;
    };

    class TEventParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TEventRow>;

        explicit TEventParser(const NCrypto::TDecryptor& decryptor,
                              NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

        TEventRow TryParse(TStringBuf line) const;

    private:
        TResult Result_;
        const NCrypto::TDecryptor& Decryptor_;
    };
}
