#include "mail_user_journal_parser.h"

#include <util/string/cast.h>

namespace NPassport::NLbchdb::NParser {
    bool TMailUserJournalRow::operator==(const TMailUserJournalRow& r) const {
        return Uid == r.Uid && Date == r.Date && Tskv == r.Tskv;
    }

    TMailUserJournalParser::TMailUserJournalParser(NUtils::ILogger* logger)
        : TParserWithBadLineLog(TLogTypeTraits{}, ELogType::MailUserJournal, logger)
    {
    }

    TMailUserJournalParser::TResult TMailUserJournalParser::Parse(const NLb::TData& data) {
        ParseRows(data);
        return std::move(Result_);
    }

    bool TMailUserJournalParser::ParseRow(TStringBuf line) {
        Result_.emplace_back(TryParse(line));
        return true;
    }

    void TMailUserJournalParser::Reserve(size_t size) {
        Result_.reserve(Result_.size() + size);
    }

    TMailUserJournalRow TMailUserJournalParser::TryParse(TStringBuf line) {
        TMailUserJournalRow res;
        res.Tskv.Reset(line,
                       NRowParsers::TTskvPolicy{
                           .Escape = NRowParsers::ETskvEscapePolicy::KeepAsIs,
                       });

        res.Tskv.GetNum("uid", res.Uid);
        res.Tskv.GetNum("date", res.Date);

        {
            ui64 tmp;
            res.Tskv.GetOptionalNum("v", tmp);
        }

        for (auto& [key, value] : res.Tskv.MutateFields()) {
            if (value == "-") {
                value.Clear();
            }
        }

        return res;
    }
}
