#pragma once

#include <passport/infra/daemons/lbchdb/src/processor.h>

#include <passport/infra/libs/cpp/logbroker/types.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

namespace NPassport::NLbchdb::NParser {
    struct TMailUserJournalRow: TMoveOnly {
        ui64 Uid = 0;
        time_t Date = 0;
        NRowParsers::TTskvRow Tskv;

        bool operator==(const TMailUserJournalRow& r) const;

        TStringBuf GetField(TStringBuf name) const {
            return Tskv.GetOptionalField(name);
        }
    };

    class TMailUserJournalParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TMailUserJournalRow>;

        TMailUserJournalParser(NUtils::ILogger* logger = nullptr);
        TResult Parse(const NLb::TData& data);

        static TMailUserJournalRow TryParse(TStringBuf line);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

    private:
        TResult Result_;
    };
}
