#pragma once

#include <passport/infra/daemons/lbchdb/src/processor.h>

#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>

#include <optional>

namespace NPassport::NLbchdb::NParser {
    struct TOAuthRow: TMoveOnly {
        TInstant Timestamp;
        TString TokenId;
        TString ClientId;
        TString DeviceId;
        TString DeviceName;
        TString Scopes;
        TString UserIp;
        ui64 Uid = 0;

        bool operator==(const TOAuthRow& o) const;
    };

    class TOAuthParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TOAuthRow>;

        explicit TOAuthParser(NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

        static std::optional<TOAuthRow> TryParse(TStringBuf line);

    private:
        TResult Result_;
    };
}
