#include "push_parser.h"

#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

namespace NPassport::NLbchdb::NParser {
    bool TPushRow::operator==(const TPushRow& r) const {
        return Uid == r.Uid &&
               Unixtime == r.Unixtime &&
               PushId == r.PushId &&
               SubscriptionId == r.SubscriptionId &&
               AppId == r.AppId &&
               DeviceId == r.DeviceId &&
               PushService == r.PushService &&
               PushEvent == r.PushEvent &&
               Details == r.Details &&
               Status == r.Status &&
               Context == r.Context;
    }

    TPushParser::TPushParser(NUtils::ILogger* logger)
        : TParserWithBadLineLog(TLogTypeTraits{}, ELogType::Push, logger)
    {
    }

    TPushParser::TResult TPushParser::Parse(const NLb::TData& data) {
        ParseRows(data);
        return std::move(Result_);
    }

    bool TPushParser::ParseRow(TStringBuf line) {
        std::optional<TPushRow> row = TryParse(line);
        if (row) {
            Result_.emplace_back(std::move(*row));
            return true;
        }
        return false;
    }

    void TPushParser::Reserve(size_t size) {
        Result_.reserve(Result_.size() + size);
    }

    std::optional<TPushRow> TPushParser::TryParse(TStringBuf line) {
        TPushRow res;
        NRowParsers::TTskvRow tskv(line);

        tskv.GetNum("uid", res.Uid);
        res.Unixtime = tskv.GetUnixtime("unixtime");

        res.PushId = tskv.GetField("push_id");
        res.SubscriptionId = tskv.GetField("subscription_id");

        res.AppId = tskv.GetOptionalField("app_id");
        res.DeviceId = tskv.GetOptionalField("device_id");

        res.PushService = tskv.GetOptionalField("push_service");
        res.PushEvent = tskv.GetOptionalField("push_event");

        res.Details = tskv.GetOptionalField("details");

        res.Status = tskv.GetOptionalField("status");
        res.Context = tskv.GetOptionalField("context");

        return res;
    }
}
