#pragma once

#include <passport/infra/daemons/lbchdb/src/processor.h>

#include <passport/infra/libs/cpp/logbroker/types.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>

namespace NPassport::NLbchdb::NParser {
    struct TPushRow: TMoveOnly {
        ui64 Uid = 0;
        TInstant Unixtime;

        TString PushId;
        TString SubscriptionId;
        TString AppId;
        TString DeviceId;

        TString PushService;
        TString PushEvent;

        TString Details;

        TString Status;
        TString Context;

        bool operator==(const TPushRow& r) const;
    };

    class TPushParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TPushRow>;

        TPushParser(NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

        static std::optional<TPushRow> TryParse(TStringBuf line);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

    private:
        TResult Result_;
    };
}
