#include "push_subscription_parser.h"

#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

namespace NPassport::NLbchdb::NParser {
    bool TPushSubscriptionRow::operator==(const TPushSubscriptionRow& r) const {
        return Uid == r.Uid &&
               AppId == r.AppId &&
               DeviceId == r.DeviceId &&
               Unixtime == r.Unixtime;
    }

    TPushSubscriptionParser::TPushSubscriptionParser(NUtils::ILogger* logger)
        : TParserWithBadLineLog(TLogTypeTraits{}, ELogType::PushSubscription, logger)
    {
    }

    TPushSubscriptionParser::TResult TPushSubscriptionParser::Parse(const NLb::TData& data) {
        ParseRows(data);
        return std::move(Result_);
    }

    TPushSubscriptionRow TPushSubscriptionParser::TryParse(TStringBuf line) {
        TPushSubscriptionRow res;
        NRowParsers::TTskvRow tskv(line);

        tskv.GetNum("uid", res.Uid);
        res.Unixtime = tskv.GetUnixtime("unixtime");

        res.AppId = tskv.GetField("app_id");
        res.DeviceId = tskv.GetField("device_id");

        return res;
    }

    bool TPushSubscriptionParser::ParseRow(TStringBuf line) {
        Result_.push_back(TryParse(line));
        return true;
    }

    void TPushSubscriptionParser::Reserve(size_t size) {
        Result_.reserve(Result_.size() + size);
    }
}
