#pragma once

#include <passport/infra/daemons/lbchdb/src/processor.h>

#include <passport/infra/libs/cpp/logbroker/types.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>

#include <util/generic/hash.h>

namespace NPassport::NLbchdb::NParser {
    struct TPushSubscriptionRow {
        ui64 Uid = 0;

        TString AppId;
        TString DeviceId;

        TInstant Unixtime;

        bool operator==(const TPushSubscriptionRow& r) const;
    };
}

template <>
struct THash<NPassport::NLbchdb::NParser::TPushSubscriptionRow> {
    size_t operator()(const NPassport::NLbchdb::NParser::TPushSubscriptionRow& t) const {
        return THash<ui64>()(t.Uid) +
               THash<TStringBuf>()(t.AppId) +
               THash<TStringBuf>()(t.DeviceId) +
               THash<TInstant>()(t.Unixtime);
    }
};

namespace NPassport::NLbchdb::NParser {
    class TPushSubscriptionParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TPushSubscriptionRow>;

        TPushSubscriptionParser(NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

        static TPushSubscriptionRow TryParse(TStringBuf line);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

    private:
        TResult Result_;
    };
}
