#include "restore_parser.h"

namespace NPassport::NLbchdb::NParser {
    TRestoreParser::TRestoreParser(const NCrypto::TDecryptor& decryptor, NUtils::ILogger* logger)
        : NLb::TParserWithBadLineLog(TLogTypeTraits{}, ELogType::Restore, logger)
        , Decryptor_(decryptor)
    {
    }

    TRestoreParser::TResult TRestoreParser::Parse(const NLb::TData& data) {
        ParseRows(data);
        return std::move(Result_);
    }

    bool TRestoreParser::ParseRow(TStringBuf line) {
        Result_.push_back(TryParse(line));
        return true;
    }

    void TRestoreParser::Reserve(size_t size) {
        Result_.reserve(Result_.size() + size);
    }

    TRestoreRow TRestoreParser::TryParse(TStringBuf line) const {
        NRowParsers::TCsvRow csv(line);
        Y_ENSURE(csv.FieldsCount() == size_t(ERestoreRow::COUNT), "Invalid field count in entry");
        TRestoreRow entry;
        ui8 version;
        Y_ENSURE(TryIntFromString<10>(csv.GetField(ERestoreRow::Version), version), "Invalid version");
        entry.Action = csv.GetField(ERestoreRow::Action);

        Y_ENSURE(version == 1 || version == 2, "Invalid version");

        {
            if (version == 2) {
                entry.DataJson = Decryptor_.Decrypt(csv.GetField(ERestoreRow::DataJson));
            } else {
                entry.DataJson = csv.GetField(ERestoreRow::DataJson);
            }
            rapidjson::Document tmp_;
            Y_ENSURE(NJson::TReader::DocumentAsObject(entry.DataJson, tmp_), "Invalid JSON file");
        }

        Y_ENSURE(TInstant::TryParseIso8601(csv.GetField(ERestoreRow::RfcTime), entry.Timestamp), "Invalid rfctime");
        Y_ENSURE(TryIntFromString<10>(csv.GetField(ERestoreRow::Uid), entry.Uid), "Invalid UID");

        entry.RestoreId = csv.GetField(ERestoreRow::RestoreId);

        return entry;
    }
}
