#pragma once

#include "event_common.h"

#include <passport/infra/daemons/lbchdb/src/processor.h>
#include <passport/infra/daemons/lbchdb/src/crypto/decryptor.h>

#include <passport/infra/libs/cpp/json/reader.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/csv_row.h>

#include <util/generic/string.h>

namespace NPassport::NLbchdb::NParser {
    enum class ERestoreRow {
        Version,
        Action,
        RfcTime,
        Uid,
        RestoreId,
        DataJson,

        COUNT
    };

    struct TRestoreRow: TMoveOnly, public TBaseEventRow {
        TStringBuf Action;
        TString DataJson;
        TStringBuf RestoreId;

        bool operator==(const TRestoreRow& o) const {
            return TBaseEventRow::operator==(o) && Action == o.Action && DataJson == o.DataJson && RestoreId == o.RestoreId;
        }
    };

    class TRestoreParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TRestoreRow>;

        explicit TRestoreParser(const NCrypto::TDecryptor& decryptor,
                                NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

        TRestoreRow TryParse(TStringBuf line) const;

    private:
        TResult Result_;
        const NCrypto::TDecryptor& Decryptor_;
    };
}
