#include "sender_delivery_parser.h"

#include <passport/infra/daemons/lbchdb/src/processor.h>
#include <passport/infra/daemons/lbchdb/src/sender_unsubsrcibe_lists.h>

namespace NPassport::NLbchdb::NParser {
    bool TSenderDeliveryRow::operator==(const TSenderDeliveryRow& o) const {
        return RecipientEmail == o.RecipientEmail &&
               UnsubscribeList == o.UnsubscribeList &&
               Ts == o.Ts;
    }

    TSenderDeliveryParser::TSenderDeliveryParser(const TSenderUnsubscribeLists& lists,
                                                 NUtils::ILogger* logger)
        : TParserWithBadLineLog(TLogTypeTraits{}, ELogType::SenderDelivery, logger)
        , Lists_(lists)
    {
    }

    TSenderDeliveryParser::TResult TSenderDeliveryParser::Parse(const NLb::TData& data) {
        ParseRows(data);
        return std::move(Result_);
    }

    bool TSenderDeliveryParser::ParseRow(TStringBuf line) {
        std::optional entry = TryParse(line);
        if (!entry) {
            return false;
        }

        Result_.push_back(std::move(*entry));
        return true;
    }

    void TSenderDeliveryParser::Reserve(size_t size) {
        Result_.reserve(Result_.size() + size);
    }

    std::optional<TSenderDeliveryRow> TSenderDeliveryParser::TryParse(TStringBuf line) const {
        try {
            Tskv_.Reset(line);
        } catch (const std::exception& e) {
            // PASSP-32388: log contains corrupted lines.
            // Nobody can fix it: do not write it to "bad_lines" to keep alert quite
            TLog::Warning() << "SenderDeliveryParser: invalid tskv: " << e.what()
                            << ". '" << line << "'";
            return {};
        }

        if (Tskv_.GetField("status") != "0") { // EMAIL_SENT == 0
            return {};
        }

        TSenderDeliveryRow res;
        res.RecipientEmail = Tskv_.GetField("recepient");
        try { // TODO: drop try-catch: PASSP-32388
            res.UnsubscribeList = Lists_.GetByAccount(Tskv_.GetField("account"));
        } catch (const std::exception& e) {
            TLog::Warning() << "SenderDeliveryParser: " << e.what();
            return {};
        }

        Tskv_.GetNum("unixtime", res.Ts);

        return res;
    }
}
