#pragma once

#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

#include <util/generic/string.h>

namespace NPassport::NLbchdb {
    class TSenderUnsubscribeLists;
}

namespace NPassport::NLbchdb::NParser {
    struct TSenderDeliveryRow: TMoveOnly {
        TString RecipientEmail;
        ui64 UnsubscribeList = 0;
        time_t Ts = 0;

        bool operator==(const TSenderDeliveryRow& o) const;
    };

    class TSenderDeliveryParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TSenderDeliveryRow>;

        TSenderDeliveryParser(const TSenderUnsubscribeLists& lists,
                              NUtils::ILogger* logger = nullptr);
        TResult Parse(const NLb::TData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

        std::optional<TSenderDeliveryRow> TryParse(TStringBuf line) const;

    private:
        TResult Result_;
        mutable NRowParsers::TTskvRow Tskv_;
        const TSenderUnsubscribeLists& Lists_;
    };
}
