#pragma once

#include <passport/infra/libs/cpp/logbroker/entity_parsers/yasms_private.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/fields_holder.h>

#include <util/generic/strbuf.h>

namespace NPassport::NLbchdb::NCrypto {
    class TDecryptor;
}

namespace NPassport::NLbchdb::NParser {
    class TYasmsPrivateRow {
    public:
        enum class EKey {
            Error,
            IsSms,
            GlobalSmsId,
            Action,
            Timestamp,
            Number,
            Uid,
            EncryptedText,

            Skip,
            Count,
        };
        using TFields = NRowParsers::TFieldsHolder<EKey>;

        TYasmsPrivateRow();

        TStringBuf GlobalSmsId;
        TStringBuf Action;
        TInstant Timestamp;
        TStringBuf Number;
        ui64 Phone = 0;
        ui64 Uid = 0;
        TString Text;

        const TFields::TExtraFields& ExtraFields() const {
            return Fields_.ExtraFields();
        }

        bool TryParse(TStringBuf line, const NCrypto::TDecryptor& decryptor);

    private:
        TFields Fields_;
    };

    class TYasmsPrivateParser: public NLb::TParserWithBadLineLog,
                               public NEntityParsers::TYasmsPrivateBaseParser {
    public:
        using TResult = std::vector<TYasmsPrivateRow>;

        TYasmsPrivateParser(const NCrypto::TDecryptor& decryptor,
                            NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

    protected:
        TResult Result_;
        const NCrypto::TDecryptor& Decryptor_;
    };
}
